	subroutine mvpacf(n,iklag,k,x,r)
c**********************************************************************
c
c   FORTRAN subroutine to calculate the partial autocorrelation 
c   function for a vector time series.
c
c   Input: n = an integer containing the number of observations in the
c              time series.
c          iklag = an integer containing the maximum lag for calculating
c                  the partial autocorrelation function.
c          k = an integer containing the number of time series in the
c              vector time series.
c          x = a double precision matrix of dimension n x k containing
c              the time series.
c   Output: r = a double precision real array of dimensions iklag x k x k
c               containing the partial autocorrelation function of x.
c
c   Subprograms called:
c
c   Created: 2/5/99 BKR
c   Modified: 2/10/99 BKR, 2/11/99 JLH
c
c**********************************************************************
	parameter (maxn=500, maxk=5, maxlag=10)
  	implicit double precision (a-h, p-z)
	double precision x(maxn,maxk), r(maxlag,maxk,maxk)
	double precision y(maxn,maxk*(maxlag+1))
	double precision beta(maxk*(maxlag+1),maxk)
	double precision rm(maxk*(maxlag+1),maxk*(maxlag+1))
	double precision scpe1(maxk*(maxlag+1),maxk*(maxlag+1))
	double precision d(maxk*(maxlag+1)),xmin(maxk*(maxlag+1))
	double precision xmax(maxk*(maxlag+1))
	double precision scpe2(maxk*(maxlag+1),maxk*(maxlag+1))
	double precision u1(maxn,maxk),u2(maxn,maxk)
	integer inddep(maxk),indind(maxk*maxlag)


	do i = 2,iklag
c
c    Forward Regression
c      Set up response and predictors
c
		do j = 1,k
 			inddep(j) = j
			y(1:(n-i),j) = x((i+1):n,j) 
		enddo
		do l = 1,i-1
		do j = 1,k
			indind(k*(l-1)+j) = k*l+j
			y(1:(n-i),k*l+j) = x((l+1):(n-i+l),j) 
		enddo
		enddo 
		call DRGIVN(0,n-i,k*i,y,maxn,1,k*(i-1),indind,k,inddep,0,0,1, 
     +       100.0d0*DMACH(4),beta,maxk*(maxlag+1),rm,maxk*(maxlag+1),d,
     +	   irank,dfe,scpe1,maxk*(maxlag+1),nrmiss,xmin,xmax)
		scpe1 = scpe1/dble(n-k*i-k) 
c
c     Compute residuals:
c
		do l = 1,k
		do j = 1,n-i
			u1(j,l)=y(j,l)-beta(1,l)
			do m = 1,k*(i-1)
				u1(j,l) = u1(j,l) - beta(m+1,l)*y(j,indind(m))
			enddo
		enddo
		enddo
c	     
c  Backward Regression
c   Set up response ( predictors are same as for forward recursions):
c
		do j = 1,k
			y(1:(n-i),j) = x(1:(n-i),j) 
		enddo
		call DRGIVN(0,n-i,k*i,y,maxn,1,k*(i-1),indind,k,inddep,0,0,1, 
     +       100.0d0*DMACH(4),beta,maxk*(maxlag+1),rm,maxk*(maxlag+1),d,
     +       irank,dfe,scpe2,maxk*(maxlag+1),nrmiss,xmin,xmax)
		scpe2 = scpe2/dble(n-k*i-k) 
c
c     Compute residuals:
c
		do l = 1,k
		do j = 1,n-i
			u2(j,l) = y(j,l) - beta(1,l)
			do m = 1,k*(i-1)
				u2(j,l) = u2(j,l) - beta(m+1,l)*y(j,indind(m))
			enddo
		enddo
		enddo
c
c     Compute PACF from residuals series:
c
		do l = 1,k
			do m = 1,k
				do j = 1,n-i
					r(i,l,m) = r(i,l,m) + u1(j,l)*u2(j,m)
				enddo
				r(i,l,m) = r(i,l,m)/dble(n-i+1)
				r(i,l,m) = r(i,l,m)/dsqrt(scpe1(l,l)*scpe2(m,m))
			enddo
		enddo
c
      enddo
c
	return
	end
